<?php

namespace Drupal\w3_data_upload\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\Database\Connection;
use Drupal\Core\Messenger\Messenger;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\file\Entity\File;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Drupal\node\Entity\Node;
use Drupal\Core\Link;
use Drupal\views\Views;
use Drupal\user\Form\UserLoginForm;
use Drupal\Core\File\FileSystemInterface;
use Drupal\datetime\Plugin\Field\FieldType\DateTimeItemInterface;
use Drupal\Core\Datetime\DrupalDateTime;
use Drupal\taxonomy\Entity\Term;
use Drupal\path_alias\Entity\PathAlias;
use Drupal\menu_link_content\Entity\MenuLinkContent;
use \Drupal\Core\Url;
use \Drupal\Component\Utility\UrlHelper;
use Drupal\paragraphs\Entity\Paragraph;
use Drupal\media\Entity\Media;

/**
 * Provides route responses for landing-page routing.
 */
class ImportDataController extends ControllerBase {

  public function content() {
    $site_link = \Drupal::config('we_data_import.theme_settings')->get('site_basic_path');
    if (empty($site_link)) {
        echo "Please add the site basic path to continue data import"; die;
    }
    
    $output = "";
    
    $data = json_decode(file_get_contents($site_link . "/basic-page-export?token=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9"));

    $basic_page = count($data);
    
    foreach($data as $row){
    	$values = \Drupal::entityQuery('node')->accessCheck(TRUE)->condition('title', $row->en->title)->execute();
    	$node_not_exists = empty($values);
      
      //News Import 
      if(!empty($row->en->title)) {
        $url = $row->en->field_banner_image;
        $file = "";
        $image_media = "";

        if (!empty($url)) {
          $uri = system_retrieve_file($url, $destination = NULL, $managed = FALSE, $replace = FileSystemInterface::EXISTS_RENAME);

          if (!empty($uri)) {
            // check first if the file exists for the uri    
            $files = \Drupal::entityTypeManager()
              ->getStorage('file')
              ->loadByProperties(['uri' => $uri]);
            $file = reset($files);

            // if not create a file
            if (!$file) {
              $file = File::create([
                'uri' => $uri,
              ]);
              $file->setPermanent();
              $file->save();
            }
          }
        }
        
        if (!empty($row->en->content)) {
          $body = $row->en->content;
          if(strpos($body, "[img:") !== false){
            $string = $body;
            $out = delete_all_between('[', ']', $string);
            $body = $out;
          } 
        }
        else {
            $body = "";
        }

        $node = \Drupal::entityTypeManager()->getStorage('node')->create([
          'type'       => 'page', //===here asset is the content type mechine name
          'title'      => $row->en->title,
          'body' => ['value' => $body, 'format' => 'full_html'],
          'field_page_description' => $row->en->field_page_description,
          'created' => $row->en->created,
          'changed' => $row->en->changed,
        ]);

        if (!empty($url) && !empty($file)) {
          $image_media = Media::create([
              'name' => 'My media name',
              'bundle' => 'image',
              'uid' => 1,
              'langcode' => 'en',
              'status' => 1,
              'field_media_image' => [
                'target_id' => $file->id(),
                'alt' => $row->en->title,
                'title' => $row->en->title,
              ],
          ]);
          $image_media->save();
          $node->field_banner_image_media = [
            'target_id' => $image_media->id(),
          ];
          
        //   $node->field_banner_image[] = [
        //     'target_id' => $file->id(),
        //     'alt' => $row->en->title,
        //     'title' => $row->en->title,
        //   ];
        }
        
        if ($row->en->status != '1') {
          $node->setUnpublished(false);
        }
        
        if (isset($row->en->file_attachment)) {
          foreach ($row->en->file_attachment as $key => $files) {
            $all_files = [];
            foreach($files->files as $k => $url) {
                $uri = system_retrieve_file($url, $destination = NULL, $managed = FALSE, $replace = FileSystemInterface::EXISTS_RENAME);
  
                if (!empty($uri)) {
                  // check first if the file exists for the uri    
                  $filess = \Drupal::entityTypeManager()
                    ->getStorage('file')
                    ->loadByProperties(['uri' => $uri]);
                  $file_pdf = reset($filess);
  
                  // if not create a file
                  if (!$file_pdf) {
                    $file_pdf = File::create([
                      'uri' => $uri,
                      'filename' => $k,
                    ]);
                    $file_pdf->setPermanent();
                    $file_pdf->save();
                  }
                }
              $doc_media = Media::create([
                  'bundle' => 'document',
                  'uid' => 1,
                  'langcode' => 'en',
                  'status' => 1,
                  'field_media_document' => [
                    'target_id' => $file_pdf->id(),
                  ],
                  'field_document_name' => $row->en->title,
              ]);
              $doc_media->save();
              
              $all_files[] = $doc_media->id();
            }

            $paragraph = Paragraph::create([
              'type' => 'file_attachments',
              'field_attachments_label' => $files->title,
              'field_attachment_files' => $all_files,
            ]);
            $paragraph->addTranslation( 'fr', [
              'field_attachments_label' => $row->fr->file_attachment->$key->title,
              'field_attachment_files' => $all_files,
            ]);
            // Add the paragraphs to the node's paragraphs field one by one.
            //$node->field_file_attachments->appendItem($paragraph);
            $paragraph->save();

            $current = $node->get('field_file_attachments')->getValue();
            $current[] = array(
                'target_id' => $paragraph->id(),
                'target_revision_id' => $paragraph->getRevisionId(),
              );
            $node->set('field_file_attachments', $current);
          }
        }
        // $node->set('field_meta_tags', serialize([
        //   'title' => $row[0],
        //   'description' => $row[4],
        //   //'keywords' => 'Some,Keywords',
        // ]));

        $node->save();
        
        foreach ($row->en->alias as $al) {
            PathAlias::create([
              'path' => "/node/" . $node->id(),
              'alias' => "/" . $al->alias,
              'langcode' => 'en',
            ])->save();
        }

        if (!empty($row->fr->content)) {
          $body_fr = $row->fr->content;
          if(strpos($body_fr, "[img:") !== false){
            $string = $body_fr;
            $out = delete_all_between('[', ']', $string);
            $body_fr = $out;
          } 
        }
        else {
            $body_fr = "";
        }

        
        
        if(!empty($row->fr->title)) {
            //Creating the translation French in this case
            $node_fr = $node->addTranslation('fr');
            $node_fr->title = $row->fr->title;
            if (!empty($row->fr->content)) {
                $node_fr->body->value = $body_fr;
                $node_fr->body->format = 'full_html';
            }
            $node_fr->field_page_description = $row->fr->field_page_description;
            if (!empty($image_media)) {
                  $node->field_banner_image_media = [
                    'target_id' => $image_media->id(),
                  ];
                // $node_fr->field_banner_image[] = [
                //     'target_id' => $file->id(),
                //     'alt' => $row->fr->title,
                //     'title' => $row->fr->title,
                //   ];
            }
            if ($row->fr->status != '1') {
                $node_fr->setUnpublished(false);
            }

            if (isset($row->fr->file_attachment)) {
              foreach ($row->fr->file_attachment as $files) {
                $all_files = [];
                foreach($files->files as $k => $url) {
                    $uri = system_retrieve_file($url, $destination = NULL, $managed = FALSE, $replace = FileSystemInterface::EXISTS_RENAME);
      
                    if (!empty($uri)) {
                      // check first if the file exists for the uri    
                      $filess = \Drupal::entityTypeManager()
                        ->getStorage('file')
                        ->loadByProperties(['uri' => $uri]);
                      $file = reset($filess);
      
                      // if not create a file
                      if (!$file) {
                        $file = File::create([
                          'uri' => $uri,
                          'filename' => $k,
                        ]);
                        $file->setPermanent();
                        $file->save();
                      }
                    }
                  $all_files[] = $file->id();
                }
      
                // $paragraph = Paragraph::create([
                //   'type' => 'file_attachments',
                //   'field_attachments_label' => $files->title,
                //   'field_attachment_files' => $all_files,
                //   'field_language' => 'fr'
                // ]);
                // // Add the paragraphs to the node's paragraphs field one by one.
                // //$node->field_file_attachments->appendItem($paragraph);
                // $paragraph->save();
    
                // $current = $node_fr->get('field_file_attachments')->getValue();
                // $current[] = array(
                //     'target_id' => $paragraph->id(),
                //     'target_revision_id' => $paragraph->getRevisionId(),
                //   );
                 $node_fr->set('field_file_attachments', $current);
              }
            }

            //Saving the node
            $node_fr->save();
        }
        
        foreach ($row->fr->alias as $alfr) {
            PathAlias::create([
                'path' => "/node/" . $node->id(),
                'alias' => "/" . $alfr->alias,
                'langcode' => 'fr',
            ])->save();
        }
      }
    //   if ($row->en->title == "Electoral Districts") {
    //         dump($row);die;
    //     }
      //dump($row); die;
    }

    $output .= $basic_page . " Basic pages successfully imported <br><br>";

    $data = json_decode(file_get_contents($site_link . "/news_export?token=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9"));
    $news = count($data);

    foreach($data as $row){
    	$values = \Drupal::entityQuery('node')->accessCheck(TRUE)->condition('title', $row->en->title)->execute();
    	$node_not_exists = empty($values);
      $file = "";
      $image_media = "";
      $afile = "";
      $doc_media = "";
      //News Import 
      if(!empty($row->en->title)) {
        $url = $row->en->field_banner_image;

        if (!empty($url)) {
          $uri = system_retrieve_file($url, $destination = NULL, $managed = FALSE, $replace = FileSystemInterface::EXISTS_RENAME);
          if (!empty($uri)) {
            // check first if the file exists for the uri    
            $files = \Drupal::entityTypeManager()
              ->getStorage('file')
              ->loadByProperties(['uri' => $uri]);
            $file = reset($files);

            // if not create a file
            if (!$file) {
              $file = File::create([
                'uri' => $uri,
              ]);
              $file->setPermanent();
              $file->save();
            }
          }
        }

        $afile = $row->en->field_attachment_files;

        if (!empty($afile)) {
          $auri = system_retrieve_file($afile, $destination = NULL, $managed = FALSE, $replace = FileSystemInterface::EXISTS_RENAME);
          if (!empty($uri)) {
            // check first if the file exists for the uri    
            $files = \Drupal::entityTypeManager()
              ->getStorage('file')
              ->loadByProperties(['uri' => $auri]);
            $file1 = reset($files);

            // if not create a file
            if (!$file1) {
              $file1 = File::create([
                'uri' => $auri,
              ]);
              $file1->setPermanent();
              $file1->save();
            }
          }
        }

        $date = strtotime($row->en->field_news_date);
        $now = DrupalDateTime::createFromTimestamp($date);
        $now->setTimezone(new \DateTimeZone('UTC'));
        
        if ($row->en->field_promote == "1") {
            $promote = '1';
        }
        else {
            $promote = '0';
        }
        
        
        $node = \Drupal::entityTypeManager()->getStorage('node')->create([
          'type'       => 'news', //===here asset is the content type mechine name
          'title'      => $row->en->title,
          'body' => ['value' => $row->en->body, 'format' => 'full_html'],
          'field_date' => $now->format('Y-m-d'),
          'field_promote' => $promote,
          'created' => $row->en->created,
          'changed' => $row->en->changed,
        ]);

        if (!empty($url)) {
          $image_media = Media::create([
              'name' => 'My media name',
              'bundle' => 'image',
              'uid' => 1,
              'langcode' => 'en',
              'status' => 1,
              'field_media_image' => [
                'target_id' => $file->id(),
                'alt' => $row->en->title,
                'title' => $row->en->title,
              ],
          ]);
          $image_media->save();
          $node->field_banner_image_media = [
            'target_id' => $image_media->id(),
          ];
        //   $node->field_banner_image[] = [
        //     'target_id' => $file->id(),
        //     'alt' => $row->en->title,
        //     'title' => $row->en->title,
        //   ];
        }

        if (!empty($afile)) {
            $doc_media = Media::create([
                  'bundle' => 'document',
                  'uid' => 1,
                  'langcode' => 'en',
                  'status' => 1,
                  'field_media_document' => [
                    'target_id' => $file1->id(),
                  ],
                  'field_document_name' => $row->en->field_document_name,
                  'field_file_name' => $row->en->filename_field,
            ]);
            $doc_media->save();
            $node->field_attachment_files[] = [
              'target_id' => $doc_media->id(),
            ];
        }
        
        if ($row->en->status != '1') {
          $node->setUnpublished(false);
        }

        $node->save();
        
        
        if ($row->fr->field_promote == "1") {
            $promote = '1';
        }
        else {
            $promote = '0';
        }
        
        if(!empty($row->fr->title)) {
            //Creating the translation French in this case
            $node_fr = $node->addTranslation('fr');
            $node_fr->title = $row->fr->title;
            $node_fr->body->value = $row->fr->body;
            $node_fr->body->format = 'full_html';
            $node_fr->field_date = $row->fr->field_news_date;
            $node_fr->field_promote = $promote;

            if (!empty($url)) {
                $image_media = Media::create([
                      'name' => 'My media name',
                      'bundle' => 'image',
                      'uid' => 1,
                      'langcode' => 'en',
                      'status' => 1,
                      'field_media_image' => [
                        'target_id' => $file->id(),
                        'alt' => $row->en->title,
                        'title' => $row->en->title,
                      ],
                  ]);
                  $image_media->save();
                  $node->field_banner_image_media = [
                    'target_id' => $image_media->id(),
                  ];
            }
            // if (!empty($afile)) {
            //     $doc_media = Media::create([
            //       'bundle' => 'document',
            //       'uid' => 1,
            //       'langcode' => 'fr',
            //       'status' => 1,
            //       'field_media_document' => [
            //         'target_id' => $file1->id(),
            //       ],
            //       'field_document_name' => $row->en->field_document_name,
            //       'field_file_name' => $row->en->filename_field,
            //     ]);
            //     $doc_media->save();
            //     $node_fr->field_attachment_files[] = [
            //       'target_id' => $doc_media->id(),
            //     ];
            // }
            //$node_fr->set('field_event_date', $dtimeFormat);

            if ($row->fr->status != '1') {
                $node_fr->setUnpublished(false);
            }
            //Saving the node
            $node_fr->save();
        }
      }
    }

    $output .=  $news . " News successfully imported <br><br>"; 

    // Event Export
    $data = json_decode(file_get_contents($site_link . "/event_export?token=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9"));
    $event = count($data);

    foreach($data as $row){
    	$values = \Drupal::entityQuery('node')->accessCheck(TRUE)->condition('title', $row->en->title)->execute();
    	$node_not_exists = empty($values);
      $file = "";
      $image_media = "";
      $afile = "";
      $doc_media = "";
      //News Import 
      if(!empty($row->en->title)) {
        $url = $row->en->field_banner_image;

        if (!empty($url)) {
          $uri = system_retrieve_file($url, $destination = NULL, $managed = FALSE, $replace = FileSystemInterface::EXISTS_RENAME);

          if (!empty($uri)) {
            // check first if the file exists for the uri    
            $files = \Drupal::entityTypeManager()
              ->getStorage('file')
              ->loadByProperties(['uri' => $uri]);
            $file = reset($files);

            // if not create a file
            if (!$file) {
              $file = File::create([
                'uri' => $uri,
              ]);
              $file->setPermanent();
              $file->save();
            }
          }
        }

        $aurl = $row->en->field_attachment_files;

        if (!empty($aurl)) {
          $auri = system_retrieve_file($aurl, $destination = NULL, $managed = FALSE, $replace = FileSystemInterface::EXISTS_RENAME);

          if (!empty($auri)) {
            // check first if the file exists for the uri    
            $files = \Drupal::entityTypeManager()
              ->getStorage('file')
              ->loadByProperties(['uri' => $auri]);
            $afile = reset($files);

            // if not create a file
            if (!$afile) {
              $afile = File::create([
                'uri' => $auri,
              ]);
              $afile->setPermanent();
              $afile->save();
            }
          }
        }


        $date = strtotime($row->en->field_event_date);
        $now = DrupalDateTime::createFromTimestamp($date);
        $now->setTimezone(new \DateTimeZone('UTC'));
        
        if ($row->en->field_promote == "1") {
            
            $promote = '1';
        }
        else {

            $promote = '0';
        }
        
        $node = \Drupal::entityTypeManager()->getStorage('node')->create([
          'type'       => 'event', //===here asset is the content type mechine name
          'title'      => $row->en->title,
          'body' => ['value' => $row->en->content, 'format' => 'full_html'],
          'field_approximate_date' => $row->en->field_approximate_date,
          'field_promote' => $promote,
          'created' => $row->en->created,
          'changed' => $row->en->changed,
        ]);

        if (!empty($url)) {
          $image_media = Media::create([
              'name' => 'My media name',
              'bundle' => 'image',
              'uid' => 1,
              'langcode' => 'en',
              'status' => 1,
              'field_media_image' => [
                'target_id' => $file->id(),
                'alt' => $row->en->title,
                'title' => $row->en->title,
              ],
          ]);
          $image_media->save();
          $node->field_banner_image_media = [
            'target_id' => $image_media->id(),
          ];
        //   $node->field_banner_image[] = [
        //     'target_id' => $file->id(),
        //     'alt' => $row->en->title,
        //     'title' => $row->en->title,
        //   ];
        }

        if (!empty($aurl)) {
            $node->field_attachment_files[] = [
              'target_id' => $afile->id(),
            ];
            $doc_media = Media::create([
              'bundle' => 'document',
              'uid' => 1,
              'langcode' => 'en',
              'status' => 1,
              'field_media_document' => [
                'target_id' => $afile->id(),
              ],
              'field_document_name' => $row->en->field_document_name,
              'field_file_name' => $row->en->filename_field,
            ]);
            $doc_media->save();
            $node->field_attachment_files[] = [
              'target_id' => $doc_media->id(),
            ];
        }
        
        if ($row->en->status != '1') {
          $node->setUnpublished(false);
        }

        $node->set('field_event_date', $now->format('Y-m-d'));

        // $node->set('field_meta_tags', serialize([
        //   'title' => $row[0],
        //   'description' => $row[4],
        //   //'keywords' => 'Some,Keywords',
        // ]));

        $node->save();
        
        if ($row->fr->field_promote == "1") {
            $promote = '1';
        }
        else {
            $promote = '0';
        }
        
        if(!empty($row->fr->title)) {
            //Creating the translation French in this case
            $node_fr = $node->addTranslation('fr');
            $node_fr->title = $row->fr->title;
            $node_fr->body->value = $row->fr->content;
            $node_fr->body->format = 'full_html';
            $node_fr->field_approximate_date = $row->fr->field_approximate_date;
            $node_fr->field_promote = $promote;

            if (!empty($url)) {
                $node_fr->field_banner_image[] = [
                    'target_id' => $file->id(),
                    'alt' => $row->fr->title,
                    'title' => $row->fr->title,
                  ];
            }
            if (!empty($aurl)) {
                $node_fr->field_attachment_files[] = [
                  'target_id' => $afile->id(),
                ];
            }
            $node_fr->set('field_event_date', $now->format('Y-m-d'));

            if ($row->fr->status != '1') {
                $node_fr->setUnpublished(false);
            }
            //Saving the node
            $node_fr->save();
        }
        
        // PathAlias::create([
        //     'path' => "/node/" . $node->id(),
        //     'alias' => str_replace('https://afforum.org', '', $row[6]),
        //     'langcode' => 'en',
        // ])->save();
      }
      
    }
    
    
    $output .= $event . " Events successfully imported <br><br>";
    

    
    
    
    $data = json_decode(file_get_contents($site_link . "/job_opportunities?token=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9"));
    $basic_page = count($data);

    foreach($data as $row){
    	$values = \Drupal::entityQuery('node')->accessCheck(TRUE)->condition('title', $row->en->title)->execute();
    	$node_not_exists = empty($values);
      
      //News Import 
      if(!empty($row->en->title)) {
        $url = $row->en->field_banner_image;

        if (!empty($url)) {
          $uri = system_retrieve_file($url, $destination = NULL, $managed = FALSE, $replace = FileSystemInterface::EXISTS_RENAME);

          if (!empty($uri)) {
            // check first if the file exists for the uri    
            $files = \Drupal::entityTypeManager()
              ->getStorage('file')
              ->loadByProperties(['uri' => $uri]);
            $file = reset($files);

            // if not create a file
            if (!$file) {
              $file = File::create([
                'uri' => $uri,
              ]);
              $file->setPermanent();
              $file->save();
            }
          }
        }
        
        if (!empty($row->en->content)) {
          $body = $row->en->content;
          if(strpos($body, "[img:") !== false){
            $string = $body;
            $out = delete_all_between('[', ']', $string);
            $body = $out;
          } 
        }
        else {
            $body = "";
        }

        $node = \Drupal::entityTypeManager()->getStorage('node')->create([
          'type'       => 'job_opportunities', //===here asset is the content type mechine name
          'title'      => $row->en->title,
          'body' => ['value' => $body, 'format' => 'full_html'],
          'created' => $row->en->created,
          'changed' => $row->en->changed,
        ]);

        if (!empty($url)) {
          $node->field_banner_image[] = [
            'target_id' => $file->id(),
            'alt' => $row->en->title,
            'title' => $row->en->title,
          ];
        }
        
        if ($row->en->status != '1') {
          $node->setUnpublished(false);
        }

        // $node->set('field_meta_tags', serialize([
        //   'title' => $row[0],
        //   'description' => $row[4],
        //   //'keywords' => 'Some,Keywords',
        // ]));

        $node->save();

        PathAlias::create([
          'path' => "/node/" . $node->id(),
          'alias' => "/" . $row->en->alias,
          'langcode' => 'en',
        ])->save();

        if (!empty($row->fr->content)) {
          $body_fr = $row->fr->content;
          if(strpos($body_fr, "[img:") !== false){
            $string = $body_fr;
            $out = delete_all_between('[', ']', $string);
            $body_fr = $out;
          } 
        }
        else {
            $body_fr = "";
        }
        
        if(!empty($row->fr->title)) {
            //Creating the translation French in this case
            $node_fr = $node->addTranslation('fr');
            $node_fr->title = $row->fr->title;
            if (!empty($row->fr->content)) {
                $node_fr->body->value = $body_fr;
                $node_fr->body->format = 'full_html';
            }
            //$node_fr->field_page_description = $row->fr->field_page_description;
            if (!empty($url)) {
                $node_fr->field_banner_image[] = [
                    'target_id' => $file->id(),
                    'alt' => $row->fr->title,
                    'title' => $row->fr->title,
                  ];
            }
            if ($row->fr->status != '1') {
                $node_fr->setUnpublished(false);
            }
            //Saving the node
            $node_fr->save();
        }

        if (!empty($row->fr->alias)) {
          PathAlias::create([
              'path' => "/node/" . $node->id(),
              'alias' => "/" . $row->fr->alias,
              'langcode' => 'fr',
          ])->save();
        }
        else {
            PathAlias::create([
                'path' => "/node/" . $node->id(),
                'alias' => "/node/" . $node->id(),
                'langcode' => 'fr',
            ])->save();
        }
      }
      
    }

    $output .= $basic_page . " Job Opportunities successfully imported <br><br>"; 


    $data = json_decode(file_get_contents($site_link . "/user_export?token=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9"));
    $user_count = count($data);

    foreach ($data as $us) {
      if ($us->name != 'admin' && !empty($us->name)) {
        $ids = \Drupal::entityQuery('user')->accessCheck(TRUE)
            ->condition('name', $us->name)
            ->range(0, 1)
            ->execute();
        if(empty($ids)){
          
            $language = \Drupal::languageManager()->getCurrentLanguage()->getId();
            $user = \Drupal\user\Entity\User::create();
    
            // Mandatory.
            $user->setPassword($us->pass);
            $user->enforceIsNew();
            $user->setEmail($us->mail);
            $user->setUsername($us->name);
    
            // Optional.
            $user->set('init', $us->mail);
            $user->set('langcode', $language);
            $user->set('preferred_langcode', $language);
            $user->set('preferred_admin_langcode', $language);
            $user->set('timezone', $us->timezone);
    
            if (in_array('translator', (array) $us->roles)) {
              $user->addRole('translator');
            }
            elseif(in_array('administrator', (array) $us->roles)) {
              $user->addRole('administrator');
            }
            elseif(in_array('site administrator', (array) $us->roles)) {
              $user->addRole('site_administrator');
            }
            elseif(in_array('editor', (array) $us->roles)) {
              $user->addRole('content_editor');
            }
    
            
            $user->activate();
    
            // Save user account.
            $result = $user->save();
        }
      }
    }

    $output .= $user_count . " Users successfully imported <br><br>"; 

    // FAQ grouping taxonomy
    $data = json_decode(file_get_contents($site_link . "/faq_grouping_export?token=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9"));
    $faq_item = count($data);
    $i = 1;
    foreach($data as $row){

      $term = Term::create([
        'name' => $row->en, 
        'vid' => 'faq_grouping',
        'weight' => $i
      ]);
      $term->save();

      $term->addTranslation('fr', [
        'name' => $row->fr,
        'weight' => $i
      ])->save();
      $i++;
    }
    
    $output .= $faq_item . " Faq taxonomy successfully imported <br><br>"; 


    $data = json_decode(file_get_contents($site_link . "/home_page_video_export?token=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9"));
    $home_page_video = count($data);

    foreach($data as $row){
    	$values = \Drupal::entityQuery('node')->accessCheck(TRUE)->condition('title', $row->en->title)->execute();
    	$node_not_exists = empty($values);

      //home page slide Import 
      if(!empty($row->en->title)) {
        if (isset($row->en->field_slide_image) && !empty($row->en->field_slide_image)) {
            $url = $row->en->field_slide_image;
    
            if (!empty($url)) {
              $uri = system_retrieve_file($url, $destination = NULL, $managed = FALSE, $replace = FileSystemInterface::EXISTS_RENAME);
              if (!empty($uri)) {
                // check first if the file exists for the uri    
                $files = \Drupal::entityTypeManager()
                  ->getStorage('file')
                  ->loadByProperties(['uri' => $uri]);
                $file = reset($files);
      
                // if not create a file
                if (!$file) {
                  $file = File::create([
                    'uri' => $uri,
                  ]);
                  $file->setPermanent();
                  $file->save();
                }
              }
            }
        }

        $node = \Drupal::entityTypeManager()->getStorage('node')->create([
          'type'       => 'home_page_video', //===here asset is the content type mechine name
          'title'      => $row->en->title,
          'field_video' => $row->en->field_video,
          'created' => $row->en->created,
          'changed' => $row->en->changed,
        ]);
       
        
        if ($row->en->status != '1') {
          $node->setUnpublished(false);
        }

        $node->save();

      }
    }

    $output .=  $home_page_video . " Home page video successfully imported <br><br>"; 

    $data = json_decode(file_get_contents($site_link . "/home_page_slide_export?token=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9"));
    $home_page_slide = count($data);

    foreach($data as $row){
    	$values = \Drupal::entityQuery('node')->accessCheck(TRUE)->condition('title', $row->en->title)->execute();
    	$node_not_exists = empty($values);

      //home page slide Import 
      if(!empty($row->en->title)) {
        $url = $row->en->field_slide_image;

        if (!empty($url)) {
          $uri = system_retrieve_file($url, $destination = NULL, $managed = FALSE, $replace = FileSystemInterface::EXISTS_RENAME);
          if (!empty($uri)) {
            // check first if the file exists for the uri    
            $files = \Drupal::entityTypeManager()
              ->getStorage('file')
              ->loadByProperties(['uri' => $uri]);
            $file = reset($files);

            // if not create a file
            if (!$file) {
              $file = File::create([
                'uri' => $uri,
              ]);
              $file->setPermanent();
              $file->save();
            }
          }
        }

        $node = \Drupal::entityTypeManager()->getStorage('node')->create([
          'type'       => 'home_page_slide', //===here asset is the content type mechine name
          'title'      => $row->en->title,
          'field_slide_description' => ['value' => $row->en->content, 'format' => 'full_html'],
          'field_sort_order' => $row->en->field_sort_order,
          'created' => $row->en->created,
          'changed' => $row->en->changed,
        ]);
        if (!empty($row->en->field_slide_link)) {
            //$node->field_slide_link->uri = $row->en->field_slide_link;
        }

        if (!empty($url)) {
            $node->field_slide_image[] = [
              'target_id' => $file->id(),
              'alt' => $row->en->title,
              'title' => $row->en->title,
            ];
        }
        
        if ($row->en->status != '1') {
          $node->setUnpublished(false);
        }

        $node->save();
        
        if(!empty($row->fr->title)) {
            //Creating the translation French in this case
            $node_fr = $node->addTranslation('fr');
            $node_fr->title = $row->fr->title;
            //$node_fr->field_sort_order = $row->fr->field_sort_order;
            $node_fr->field_slide_description->value = $row->fr->content;
            $node_fr->field_slide_description->format = 'full_html';
            if (!empty($row->en->field_slide_link)) {
               // $node_fr->field_slide_link->uri = $row->en->field_slide_link;
            }
            if ($row->fr->status != '1') {
                $node_fr->setUnpublished(false);
            }

            if (!empty($url)) {
                $node_fr->field_slide_image[] = [
                  'target_id' => $file->id(),
                  'alt' => $row->en->title,
                  'title' => $row->en->title,
                ];
            }
            //Saving the node
            $node_fr->save();
        }
      }
    }

    $output .=  $home_page_slide . " Home page sliders successfully imported <br><br>";
    
    $data = json_decode(file_get_contents($site_link . "/faq_export?token=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9"));
    $faq_item = count($data);

    foreach($data as $row){
    	$values = \Drupal::entityQuery('node')->accessCheck(TRUE)->condition('title', $row->en->title)->execute();
    	$node_not_exists = empty($values);

      //Faq Import 
      if(!empty($row->en->title)) {

        $termId= \Drupal::entityQuery("taxonomy_term")->accessCheck(TRUE)->condition("vid", "faq_grouping")->condition("name", $row->en->faq_grouping)->execute();
        $tid = array_values($termId);
        
        preg_match_all('!\d+!', $row->en->title, $matches);

        $node = \Drupal::entityTypeManager()->getStorage('node')->create([
          'type'       => 'faq_item', //===here asset is the content type mechine name
          'title'      => $row->en->title,
          'body' => ['value' => $row->en->content, 'format' => 'full_html'],
          'created' => $row->en->created,
          'changed' => $row->en->changed,
          'field_sort' => $matches[0][0],
        ]);

        $node->set('field_faq_grouping', $tid[0]);
        
        if ($row->en->status != '1') {
          $node->setUnpublished(false);
        }

        $node->save();
        
        if(!empty($row->fr->title)) {
            //Creating the translation French in this case
            $node_fr = $node->addTranslation('fr');
            $node_fr->title = $row->fr->title;
            $node_fr->body->value = $row->fr->content;
            $node_fr->body->format = 'full_html';
            $node_fr->set('field_faq_grouping', $tid[0]);
            $node_fr->set('field_sort', $matches[0][0]);
            if ($row->fr->status != '1') {
                $node_fr->setUnpublished(false);
            }
            //Saving the node
            $node_fr->save();
        }
      }

    }

    $output .=  $faq_item . " Faq items successfully imported <br><br>";


    $data = json_decode(file_get_contents($site_link . "/call-to-action-export?token=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9"));
    $call_to_action = count($data);

    foreach($data as $row){
    	$values = \Drupal::entityQuery('node')->accessCheck(TRUE)->condition('title', $row->en->title)->execute();
    	$node_not_exists = empty($values);

      //News Import 
      if(!empty($row->en->title)) {
        $url = $row->en->field_logo;

        if (!empty($url)) {
          $uri = system_retrieve_file($url, $destination = NULL, $managed = FALSE, $replace = FileSystemInterface::EXISTS_RENAME);
          if (!empty($uri)) {
            // check first if the file exists for the uri    
            $files = \Drupal::entityTypeManager()
              ->getStorage('file')
              ->loadByProperties(['uri' => $uri]);
            $file = reset($files);

            // if not create a file
            if (!$file) {
              $file = File::create([
                'uri' => $uri,
              ]);
              $file->setPermanent();
              $file->save();
            }
          }
        }

        $node = \Drupal::entityTypeManager()->getStorage('node')->create([
          'type'       => 'call_to_action', //===here asset is the content type mechine name
          'title'      => $row->en->title,
          'body' => ['value' => $row->en->content, 'format' => 'full_html'],
          'field_display_order' => $row->en->field_display_order,
          'created' => $row->en->created,
          'changed' => $row->en->changed,
        ]);

        if (!empty($url)) {
          $node->field_logo[] = [
            'target_id' => $file->id(),
            'alt' => $row->en->title,
            'title' => $row->en->title,
          ];
        }

        if (!empty($row->en->field_link)) {
            //$node->field_link->uri = $row->en->field_link;
        }
        
        if ($row->en->status != '1') {
          $node->setUnpublished(false);
        }

        // $node->set('field_meta_tags', serialize([
        //   'title' => $row[0],
        //   'description' => $row[4],
        //   //'keywords' => 'Some,Keywords',
        // ]));

        $node->save();
        
        if(!empty($row->fr->title)) {
            //Creating the translation French in this case
            $node_fr = $node->addTranslation('fr');
            $node_fr->title = $row->fr->title;
            $node_fr->body->value = $row->fr->content;
            $node_fr->body->format = 'full_html';
            $node_fr->field_display_order = $row->fr->field_display_order;
            if (!empty($url)) {
                $node_fr->field_logo[] = [
                    'target_id' => $file->id(),
                    'alt' => $row->fr->title,
                    'title' => $row->fr->title,
                  ];
            }
            if (!empty($row->en->field_link)) {
               // $node->field_link->uri = $row->en->field_link;
            }
            if ($row->fr->status != '1') {
                $node_fr->setUnpublished(false);
            }
            //Saving the node
            $node_fr->save();
        }

      }
    }


    $output .=  $call_to_action . " Call to actions successfully imported <br><br>";
    
    $data = json_decode(file_get_contents($site_link . "/menu_wet_footer_export?token=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9"));
    $main_menu = count($data);

    $menu_link_storage = \Drupal::entityTypeManager()->getStorage('menu_link_content');

    $my_menu = $menu_link_storage->loadByProperties(['menu_name' => 'quick-links']);

    foreach($data as $row){
          if ($row->en->title != 'Home' && !empty($row->en->title)) {

            $alias = \Drupal::service('path_alias.manager')->getPathByAlias($row->en->link);
            
            
                if (strpos($alias, 'node') !== false) {
                    $menu_item = MenuLinkContent::create([
                      'bundle' => 'menu_link_content',
                      'langcode' => 'en',
                      'title' => $row->en->title,
                      'menu_name' => 'quick-links',
                      'link' => ['uri' => 'internal:' . $alias],
                      'weight' => $row->en->weight,
                    ]);
                    $menu_item->save();
                    
                    if (!empty($row->fr->title)) {
                      $menu_item_fr = $menu_item->addTranslation('fr');
                      $menu_item_fr->title = $row->fr->title;
                      $menu_item_fr->link = ['uri' => 'internal:' . $alias];
                      $menu_item_fr->weight = $row->fr->weight;
                      $menu_item_fr->save();
                    }
                } 
                else {
                    $params = Url::fromUri('internal:/'.$row->en->link)->getRouteParameters();
                    $entity_type = key($params);
                    $node = \Drupal::entityTypeManager()->getStorage($entity_type)->load($params[$entity_type]);
                    
                    $menu_item = MenuLinkContent::create([
                        'bundle' => 'menu_link_content',
                        'langcode' => 'en',
                        'title' => $row->en->title,
                        'menu_name' => 'quick-links',
                        'link' => ['uri' => 'internal:/node/' . $node->id()],
                        'weight' => $row->en->weight,
                    ]);
                    $menu_item->save();
            
                    if (!empty($row->fr->title)) {
                        $menu_item_fr = $menu_item->addTranslation('fr');
                        $menu_item_fr->title = $row->fr->title;
                        $menu_item_fr->link = ['uri' => 'internal:/node/' . $node->id()];
                        $menu_item_fr->weight = $row->fr->weight;
                        $menu_item_fr->save();
                    }
                }

        }
    }
    
    $data = json_decode(file_get_contents($site_link . "/top_menu_export?token=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9"));
    $main_menu = count($data);

    $menu_link_storage = \Drupal::entityTypeManager()->getStorage('menu_link_content');

    $my_menu = $menu_link_storage->loadByProperties(['menu_name' => 'main']);

    foreach($data as $row){
      if ($row->en->title != 'Home') {
          

        if ($row->en->title == 'Events' || $row->en->title == 'Feedback' || $row->en->title == 'Search the site') {
          $menu_item = MenuLinkContent::create([
            'bundle' => 'menu_link_content',
            'langcode' => 'en',
            'title' => $row->en->title,
            'menu_name' => 'main',
            'link' => ['uri' => 'internal:/' . $row->en->link],
            'weight' => $row->en->weight,
          ]);
          $menu_item->save();

          if (!empty($row->fr->title)) {
            $menu_item_fr = $menu_item->addTranslation('fr');
            $menu_item_fr->title = $row->fr->title;
            $menu_item_fr->link = ['uri' => 'internal:/' . $row->en->link];
            $menu_item_fr->weight = $row->fr->weight;
            $menu_item_fr->save();
          }
        }
        else {
          $alias = \Drupal::service('path_alias.manager')->getPathByAlias($row->en->link);
          $params = Url::fromUri('internal:/'.$row->en->link)->getRouteParameters();
          $entity_type = key($params);
          $node = \Drupal::entityTypeManager()->getStorage($entity_type)->load($params[$entity_type]);

          $menu_item = MenuLinkContent::create([
            'bundle' => 'menu_link_content',
            'langcode' => 'en',
            'title' => $row->en->title,
            'menu_name' => 'main',
            'link' => ['uri' => 'internal:/node/' . $node->id()],
            'weight' => $row->en->weight,
          ]);
          $menu_item->save();

          if (!empty($row->fr->title)) {
            $menu_item_fr = $menu_item->addTranslation('fr');
            $menu_item_fr->title = $row->fr->title;
            $menu_item_fr->link = ['uri' => 'internal:/node/' . $node->id()];
            $menu_item_fr->weight = $row->fr->weight;
            $menu_item_fr->save();
          }
        }

      }
    }

    $data = json_decode(file_get_contents($site_link . "/main_menu_export?token=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9"));
    $main_menu = count($data);

    $menu_link_storage = \Drupal::entityTypeManager()->getStorage('menu_link_content');

    $my_menu = $menu_link_storage->loadByProperties(['menu_name' => 'sub-menu']);

    foreach($data as $row){
      if ($row->en->title != 'Home') {

        $alias = \Drupal::service('path_alias.manager')->getPathByAlias($row->en->link);
            $params = Url::fromUri('internal:/'.$row->en->link)->getRouteParameters();
            $entity_type = key($params);
            $node = \Drupal::entityTypeManager()->getStorage($entity_type)->load($params[$entity_type]);

        $menu_item = MenuLinkContent::create([
          'bundle' => 'menu_link_content',
          'langcode' => 'en',
          'title' => $row->en->title,
          'menu_name' => 'sub-menu',
          'link' => ['uri' => 'entity:node/' . $node->id()],
          'weight' => $row->en->weight,
        ]);
        $menu_item->save();

        if (!empty($row->fr->title)) {
          $menu_item_fr = $menu_item->addTranslation('fr');
          $menu_item_fr->title = $row->fr->title;
          $menu_item_fr->link = ['uri' => 'entity:node/' . $node->id()];
          $menu_item_fr->weight = $row->fr->weight;
          $menu_item_fr->save();
        }
      }
    }
    
    $output .= "Menus successfully imported<br><br>"; 

    //Menu end
    
    
    $output .= "<a href='/'>Go to Home page</a>";
    
    return [
      '#markup' => $output,
    ];


	\Drupal::messenger()->addMessage('imported successfully');
  }

  
  }
