<?php

namespace Drupal\ey_common\Plugin\Block;

/**
 * @file
 * Contains \Drupal\ey_common\Plugin\Block\DateFilterBlock.
 */

use Drupal\Core\Block\BlockBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provide wishlist block.
 *
 * @Block(
 *   id = "date_filter_block",
 *   admin_label = @Translation("Custom date filter block"),
 * )
 */
class DateFilterBlock extends BlockBase {

  /**
   * {@inheritdoc}
   */
  public function build() {
    if (isset($_GET['date']) && $_GET['date']) {
        $current_year = $_GET['date'];
    }
    else {
        $current_year = date('Y');
    }
    
    $next_year_3 = date('Y') + 3;
    $prev_year_3 = date('Y') - 3;
    
    $next_year = $current_year + 1;
    $prev_year = $current_year - 1;
    global $base_url;
    
    $language = \Drupal::languageManager()->getCurrentLanguage()->getId();
    
    if ($next_year_3 == $current_year) {
        
        $output = '<nav class="date-views-pager clearfix date-nav-wrapper">
          <div class="item-list">
          <ul class="pagination pull-right">
          <li class="prev"><a href="'.$base_url. '/' .$language.'/events/past?date='.$prev_year.'" title="" rel="nofollow" data-toggle="tooltip" data-placement="bottom" data-original-title="Navigate to previous year">'.t("Prev").' </a></li>
        </ul></div>  
        <h3>'.$current_year.'</h3>
        </nav>';
    }
    
    elseif ($prev_year_3 == $current_year) {
        $output = '<nav class="date-views-pager clearfix date-nav-wrapper">
          <div class="item-list">
          <ul class="pagination pull-right">
        <li class="next"><a href="'.$base_url.'/' .$language.'/events/past?date='.$next_year.'" title="" rel="nofollow" data-toggle="tooltip" data-placement="bottom" data-original-title="Navigate to next year">'.t("Next").'</a></li>
        </ul></div>  
        <h3>'.$current_year.'</h3>
        </nav>';
    }
    else {
        $output = '<nav class="date-views-pager clearfix date-nav-wrapper">
          <div class="item-list">
          <ul class="pagination pull-right">
          <li class="prev"><a href="'.$base_url.'/' .$language.'/events/past?date='.$prev_year.'" title="" rel="nofollow" data-toggle="tooltip" data-placement="bottom" data-original-title="Navigate to previous year">'.t("Prev").'</a></li>
        <li class="next"><a href="'.$base_url.'/' .$language.'/events/past?date='.$next_year.'" title="" rel="nofollow" data-toggle="tooltip" data-placement="bottom" data-original-title="Navigate to next year">'.t("Next").'</a></li>
        </ul></div>  
        <h3>'.$current_year.'</h3>
        </nav>';
    }

    return [
      '#markup' => $output,
      '#cache' => ['max-age' => 0],
    ];
  }

}


