<?php

namespace Drupal\ey_common\Plugin\Block;

/**
 * @file
 * Contains \Drupal\ey_common\Plugin\Block\DateFilterBlock.
 */

use Drupal\Core\Block\BlockBase;
use Drupal\Core\Menu\MenuTreeParameters;

/**
 * Provides a 'Child Menu' block.
 *
 * @Block(
 *   id = "child_menu_block",
 *   admin_label = @Translation("Child Menu Block")
 * )
 */
class ChildMenuBlock extends BlockBase {
  public function build() {
    $menu_name = 'secondary-menu'; // Change to your menu machine name
    $current_path = \Drupal::service('path.current')->getPath();
    $route_match = \Drupal::routeMatch();
    $node = $route_match->getParameter('node');

    if ($node) {
      $current_path = $node->toUrl()->toString();
    }

    $menu_tree = \Drupal::menuTree();
    $parameters = new MenuTreeParameters();
    $parameters->onlyEnabledLinks()->setRoot($current_path);

    $tree = $menu_tree->load($menu_name, $parameters);
    $render = $menu_tree->build($tree);
    dump($parameters); die;
    return ['#markup' => render($render)];
  }
}
