<?php

/**
 * @file
 * A database agnostic dump for testing purposes.
 *
 * This file was generated by the Drupal 9.2.6 db-tools.php script.
 */

use Drupal\Core\Database\Database;

$connection = Database::getConnection();

$connection->schema()->createTable('node_type', [
  'fields' => [
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'base' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ],
    'module' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ],
    'description' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'medium',
    ],
    'help' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'medium',
    ],
    'has_title' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'unsigned' => TRUE,
    ],
    'title_label' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'custom' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ],
    'modified' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ],
    'locked' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ],
    'disabled' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ],
    'orig_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
  ],
  'primary key' => [
    'type',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('node_type')
  ->fields([
    'type',
    'name',
    'base',
    'module',
    'description',
    'help',
    'has_title',
    'title_label',
    'custom',
    'modified',
    'locked',
    'disabled',
    'orig_type',
  ])
  ->values([
    'type' => 'article',
    'name' => 'Article',
    'base' => 'node_content',
    'module' => 'node',
    'description' => 'Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.',
    'help' => '',
    'has_title' => '1',
    'title_label' => 'Title',
    'custom' => '1',
    'modified' => '1',
    'locked' => '0',
    'disabled' => '0',
    'orig_type' => 'article',
  ])
  ->execute();
