<!--- cspell:ignore werk21 -->
# CONTENTS OF THIS FILE

 * Introduction
 * Requirements
 * Installation
 * Configuration
 * FAQ
 * Maintainers

# INTRODUCTION

The *Language Switcher Menu* module allows you to add the language switch
links generated by the `language` module of Drupal Core as menu link items
to one of your menus.

For a full description of the module, visit the project page:
https://www.drupal.org/language_switcher_menu

To submit bug reports and feature suggestions, or to track changes:
https://www.drupal.org/node/add/project-issue/language_switcher_menu

# REQUIREMENTS

This module depends on the `language` module provided by Drupal Core.

# INSTALLATION

 * Install as you would normally install a contributed Drupal module. See:
   https://www.drupal.org/documentation/install/modules-themes/modules-8
   for further information.

# CONFIGURATION

 * Review the permissions provided by the module. There is one permission to
 configure the module and (for now, see below) a permission to view language
 switcher menu links added by the module.
 * Go to the configuration page of the module at Configuration > Regional
 and language > Language Switcher Menu.
 * Select the language type you want to use to generate the links.
 * Select a parent menu item. The language switcher links will be added
 below that menu item. As usual, you may select the name of a menu
 to add the links to the root level. You may select the *Disabled*
 option, if you want to (temporarily) disable the functionality of
 the module without uninstalling it.
 * Select the weight of the first language switcher link to be added
 to the menu. For any additional language switcher links, the weight
 will be increased by 1.
 * Click *Save configuration*.

### Important note

Due to [an issue in Drupal Core](https://www.drupal.org/project/drupal/issues/3008889), language switcher links added to the menu would always be invisible. As a workaround, the module won't just add the language switcher links to the menu, but will also override Drupal's *Menu Tree Manipulator* service and grant access to any language switcher menu links added by the module to any user that has the permission to *View Language Switcher Menu links*. Once that issue has been fixed, the workaround and the permission will be removed. As a result of that workaround, the module might be incompatible with other modules that also override the *Menu Tree Manipulator* service.


# FAQ

## How can I alter the generated links?

You may implement `hook_language_switch_links_alter()` provided by Drupal Core
in a custom module or use any other contributed module that implements that
hook to alter the language switcher links. Alternatively, you may
override `menu.html.twig` in your custom theme (see below) or implement
a preprocess function.

## How do I target the links in Twig templates?

You can check, if the id of the menu link starts with
`language_switcher_menu.language_switcher_link:`. `item.original_link.class`
or `item.original_link.provider` are also a good candidates to check,
whether the links have been generated by Language Switcher Menu module.
If needed, you can get the language object using
`item.original_link.getOptions()['language']`. Below is an example of
a custom `menu.html.twig` template that uses custom markup for
language switcher links:

```twig
{#
/**
 * @file
 * Theme override to display a menu.
 *
 * Available variables:
 * - menu_name: The machine name of the menu.
 * - items: A nested list of menu items. Each menu item contains:
 *   - attributes: HTML attributes for the menu item.
 *   - below: The menu item child items.
 *   - title: The menu link title.
 *   - url: The menu link url, instance of \Drupal\Core\Url
 *   - localized_options: Menu link localized options.
 *   - is_expanded: TRUE if the link has visible children within the current
 *     menu tree.
 *   - is_collapsed: TRUE if the link has children within the current menu tree
 *     that are not currently visible.
 *   - in_active_trail: TRUE if the link is in the active trail.
 */
 #}
 {% import _self as menus %}

{#
  We call a macro which calls itself to render the full tree.
  @see http://twig.sensiolabs.org/doc/tags/macro.html
  #}
  {{ menus.menu_links(items, attributes, 0) }}

  {% macro menu_links(items, attributes, menu_level) %}
    {% import _self as menus %}
    {% if items %}
      {% if menu_level == 0 %}
        <ul{{ attributes.addClass('menu', 'menu--level-0') }}>
      {% else %}
        <ul class="menu menu--level-{{ menu_level}}">
        {% endif %}
        {% for id, item in items %}
          {% set classes = [
            'menu__item',
            item.is_expanded ? 'has-children',
            item.in_active_trail ? 'in-active-trail',
          ] %}
          <li{{ item.attributes.addClass(classes) }}>
            {% if id starts with 'language_switcher_menu.language_switcher_link:'
            %}
              {% set language = item.original_link.getOptions()['language'] %}
              <a href="{{ item.url }}" lang="{{ language.getId() }}"
                class="language-switcher-link">
                <abbr title="{{ item.title }}">{{ language.getId() }}</abbr>
              </a>
            {% else %}
              {{ link(item.title, item.url, { 'class':['menu__link']}) }}
            {% endif %}
            {% if item.below %}
              {{ menus.menu_links(item.below, attributes, menu_level + 1) }}
            {% endif %}
          </li>
        {% endfor %}
      </ul>
    {% endif %}
{% endmacro %}
```

# MAINTAINERS

Current maintainers:
See maintainers list on [the module's project page](https://www.drupal.org/project/language_switcher_menu).

This project has been partly sponsored by:
 * [werk21 GmbH](http://www.werk21.de )
