# Elections Yukon

A standalone Drupal instance for the Elections Yukon (electionsyukon.ca) website.

The Drupal version 7 of the Elections Yukon site was formerly hosted in a multisite
configuration with yukon.ca.
This standalone instance was migrated to Drupal v10 and severed from the yukon.ca
codebase.

## Installation

1. `composer2-81 install`
2. `cp web/sites/default/default.settings.php web/sites/default/settings.php`
3. Uncomment last 3 lines of `web/sites/default/settings.php` to enable
   `settings.local.php`.
4. Add configuration settings to `web/sites/default/settings.local.php`:
```
$settings['skip_permissions_hardening'] = FALSE;
$config['system.logging']['error_level'] = 'hide';
$config['system.performance']['css']['preprocess'] = TRUE;
$config['system.performance']['js']['preprocess'] = TRUE;
$databases['default']['default'] = ...
$settings['config_sync_directory'] = '../config/sync';
$settings['file_private_path'] = '../private';
$settings['hash_salt'] = ...
$settings['trusted_host_patterns'] = [
  '^electionsyukon10\.cms-uat\.yukon\.ca$',
  '^electionsyukon\.ca$',
];
$config['matomo.settings']['site_id'] = '43';
$config['matomo.settings']['url_http'] = 'http://analytics.gov.yk.ca/';
$config['matomo.settings']['url_https'] = 'https://analytics.gov.yk.ca/';
```
5. Create `web/sites/default/services.yml` containing only:
```
parameters: { }
services: { }
```
6. `mkdir private`
7. `sudo chown -R www-data:deploy private web/sites/default/files`
8. `sudo chmod -R g+w private web/sites/default/files`
9. Set up an Apache VirtualHost with PHP 8.1 FPM.
10. Visit the site in a browser (at `/core/install.php`) and install Drupal:
    - language: English
    - installation profile: Standard
    - site name: Elections Yukon
    - email address: eservices@yukon.ca
    - initial user: a temporary admin account not already in the D7 site to be migrated
11. `drush cset system.site uuid "b12d7f79-2f22-4029-b0d0-490a23bedcad" -y`
12. `drush cim -y`
13. `drush cr`
14. Set up an hourly cron job based on the URL at `en/admin/config/system/cron`
